﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectLocation.aspx.cs" Inherits="GUI.Pages.ProjectLocation" %>

<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>
<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavTest" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
     <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ProjectLocations %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label"><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_ProjectLocation %>" /></label>
                                        <div class="input-group">
                                           <asp:DropDownList ValidationGroup="Validacija" CssClass="form-control" runat="server" ID="ddlLocation"></asp:DropDownList>
                                            <span class="input-group-btn">
                                                <asp:LinkButton ID="btnAddLocation" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                                    <i class="fa fa-plus"></i>
                                                </asp:LinkButton>	
                                            </span>
                                        </div> 
                                        <span class="help-block"><asp:RequiredFieldValidator ID="ddlLocationRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlLocation" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                     <div class="form-actions left" style="border-top: none; margin-top: 4px;">
                                          <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                                runat="server" />
                                    </div>
                                </div>
                            </div>
                       
                        
                        <telerik:RadGrid ID="grdProjectLocations" runat="server" OnItemCommand="grdProjectLocationsItemCommand" Skin="Bootstrap" CssClass="kendo-table">
                            <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>"  CssClass="table table-striped table-hover"
                                ShowFooter="False" AutoGenerateColumns="False" AllowCustomSorting="false" DataKeyNames="Id">
                                <Columns>
                                    <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
                                    <telerik:GridBoundColumn UniqueName="CodeColumn" SortExpression="Code" HeaderText="<%$ Resources:ProjectManagementUI, Common_Code %>"
                                        DataField="ProjectLocation.Code" />
                                    <telerik:GridBoundColumn UniqueName="NameColumn" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>"
                                        DataField="ProjectLocation.NameLocalized" />
                                    <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%"
                                        ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                        ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                                </Columns>
                            </MasterTableView>
                        </telerik:RadGrid>
                        </div> 
                    </div>
                </div>
            </div>
        </div>


</asp:Content>
